import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, check_elements_in_list


atp_tennis = read_csv_file('atp_tennis.csv')

# Filter the affected matches for quarterfinals, semifinals, and finals
later_rounds = atp_tennis[check_elements_in_list(atp_tennis['Round'], ['Quarterfinals', 'Semifinals', 'Finals'])]

print(later_rounds)
pickle.dump(later_rounds,open("./ref_result/later_rounds.pkl","wb"))